<?php

require __DIR__ . '/config/autoload.php';
\set_error_handler('Ministra\\Lib\\w13ec15f0067ea75861e61e27c990e4ba\\i3754c224d4571b09d7b07bb2de9df22d', \E_ALL);
\set_exception_handler('Ministra\\Lib\\w13ec15f0067ea75861e61e27c990e4ba\\n1f65b5cf04cc2748b19a44737cffacb5');
use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\k8281faec2a4a41f470b00112682ddabf;
use Silex\Application;
$_SERVER['TARGET'] = 'ADM';
$locales = [];
$allowed_locales = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\k8281faec2a4a41f470b00112682ddabf::get('allowed_locales');
foreach ($allowed_locales as $lang => $locale) {
    $locales[\substr($locale, 0, 2)] = $locale;
}
$accept_language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : \null;
if (!empty($_COOKIE['language']) && (\array_key_exists($_COOKIE['language'], $locales) || \in_array($_COOKIE['language'], $locales))) {
    $language = \substr($_COOKIE['language'], 0, 2);
} else {
    if ($accept_language && \array_key_exists(\substr($accept_language, 0, 2), $locales)) {
        $language = \substr($accept_language, 0, 2);
    } else {
        $language = \key($locales);
    }
}
$locale = $locales[$language];
if (!\headers_sent()) {
    \setcookie('debug_key', '', \time() - 3600, '/');
    \setlocale(\LC_MESSAGES, $locale);
    \setlocale(\LC_TIME, $locale);
    \putenv('LC_MESSAGES=' . $locale);
    \bindtextdomain('stb', \PROJECT_PATH . '/locale');
    \textdomain('stb');
    \bind_textdomain_codeset('stb', 'UTF-8');
}
$app = new \Silex\Application();
$app['allowed_locales'] = $allowed_locales;
$app['language'] = $language;
$app['js_validator_language'] = \in_array($language, ['pt', 'ro', 'dk', 'no', 'nl', 'cz', 'ca', 'ru', 'it', 'fr', 'de', 'se', 'en', 'pt']) ? $language : 'en';
$app['lang'] = $lang = [$language];
$app['used_locale'] = $locale;
$app['debug'] = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\k8281faec2a4a41f470b00112682ddabf::getSafe('admin_panel_debug', \false);
require __DIR__ . '/config/prod.php';
if ($app['debug']) {
    require __DIR__ . '/config/dev.php';
}
if ($app->offsetExists('test') && $app['test'] && \is_file($file = __DIR__ . '/config/test.php')) {
    require __DIR__ . '/config/test.php';
}
require __DIR__ . '/config/providers.php';
require 'controllers.php';
return $app;
