<?php

if (!isset($app)) {
    throw new \Exception('App variable does not define');
}
use Assetic\Asset\AssetCollection;
use Assetic\Asset\FileAsset;
use Assetic\AssetWriter;
use Assetic\Filter\CssMinFilter;
use Assetic\Filter\JSMinFilter;
use Assetic\Filter\UglifyCssFilter;
use Assetic\Filter\UglifyJs2Filter;
use Assetic\Filter\Yui\CssCompressorFilter;
use Assetic\Filter\Yui\JsCompressorFilter;
use Ministra\Admin\Lib\Authentication\AccessMap;
use Ministra\Admin\Lib\EmptyTranslationExtension;
use Silex\Application;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormFactory;
$db = $app['db'];
$db->getDatabasePlatform()->registerDoctrineTypeMapping('enum', 'string');
$app->boot();
$app['twig']->addExtension(new \Ministra\Admin\Lib\EmptyTranslationExtension($app['translator']));
$app['twig']->addFunction(new \Twig_SimpleFunction('compressor', function ($option, \Silex\Application $app) {
    if (empty($option['dest_file_name'])) {
        $option['dest_file_name'] = $app['assetic_ext_min_name'] . ($option['type'] == 'css' ? '.css' : '.js');
    }
    if (\getenv('STALKER_ENV')) {
        \ini_set('memory_limit', '1024M');
        $filters = ['yui_css' => new \Assetic\Filter\Yui\CssCompressorFilter('/usr/share/yui-compressor/yui-compressor.jar'), 'yui_js' => new \Assetic\Filter\Yui\JsCompressorFilter('/usr/share/yui-compressor/yui-compressor.jar'), 'uglifyjs2' => new \Assetic\Filter\UglifyJs2Filter('/usr/local/bin/uglifyjs'), 'uglifycss' => new \Assetic\Filter\UglifyCssFilter('/usr/local/bin/uglifycss'), 'cssmin' => new \Assetic\Filter\CssMinFilter(), 'jsmin' => new \Assetic\Filter\JSMinFilter()];
        $source_path = $app['assetic_path_to_source'] . ($option['type'] == 'css' ? $app['assetic_base_css_path'] : $app['assetic_base_js_path']) . $app['twig_theme'] . '/';
        if (!empty($option['source_path'])) {
            $source_path = \substr($option['source_path'], 0, 3) == '../' ? \dirname($source_path) . '/' . \substr($option['source_path'], 3) : $source_path . $option['source_path'];
        }
        $sources = [];
        if (\is_string($option['source_file_name'])) {
            $sources = \glob(\rtrim($source_path, '/') . '/' . $option['source_file_name']);
        }
        $compressor = new \Assetic\Asset\AssetCollection([], [$filters[$option['filter']]]);
        foreach ($sources as $source) {
            $compressor->add(new \Assetic\Asset\FileAsset($source));
        }
        $destination = $app['assetic_path_to_source'] . 'min/' . $app['twig_theme'] . ($option['type'] == 'css' ? '/css/' : '/js/');
        \optionsConcat($destination, ['dest_path', 'dest_file_name'], $option);
        $compressor->setTargetPath(\trim($destination, '/'));
        $writer = new \Assetic\AssetWriter('');
        $writer->writeAsset($compressor);
        $web_path = $app['assetic_base_web_path'] . ($option['type'] == 'css' ? $app['assetic_base_css_path'] : $app['assetic_base_js_path']) . $app['twig_theme'] . '/';
        if (!empty($option['source_path'])) {
            $web_path = \substr($option['source_path'], 0, 3) == '../' ? \dirname($web_path) . '/' . \substr($option['source_path'], 3) : $web_path . $option['source_path'];
        }
        return \array_map(function ($real_path) use($web_path, $source_path) {
            return \str_replace($source_path, $web_path, $real_path);
        }, $sources);
    } else {
        $path = $app['assetic_base_web_path'] . ($option['type'] == 'css' ? $app['assetic_base_css_path'] : $app['assetic_base_js_path']);
        \optionsConcat($path, ['dest_path', 'dest_file_name'], $option);
        return [$path];
    }
}));
$app->extend('form.factory', function (\Symfony\Component\Form\FormFactory $builder) {
    $builder->createNamed('text', \Symfony\Component\Form\Extension\Core\Type\TextType::class);
    $builder->createNamed('textarea', \Symfony\Component\Form\Extension\Core\Type\TextareaType::class);
    $builder->createNamed('hidden', \Symfony\Component\Form\Extension\Core\Type\HiddenType::class);
    $builder->createNamed('choise', \Symfony\Component\Form\Extension\Core\Type\ChoiceType::class);
    $builder->createNamed('collection', \Symfony\Component\Form\Extension\Core\Type\CollectionType::class);
    $builder->createNamed('checkbox', \Symfony\Component\Form\Extension\Core\Type\CheckboxType::class);
    $builder->createNamed('submit', \Symfony\Component\Form\Extension\Core\Type\SubmitType::class);
    $builder->create('form', \Symfony\Component\Form\Extension\Core\Type\FormType::class);
    return $builder;
});
$app->offsetSet('access_map', function (\Silex\Application $app) {
    $token = $app['security.token_storage']->getToken();
    if (\null !== $token) {
        $user = $token->getUser();
    } else {
        $user = \null;
    }
    return new \Ministra\Admin\Lib\Authentication\AccessMap($app['db'], $user);
});
