<?php

namespace Ministra\Admin;

use Doctrine\DBAL\DriverManager;
use Ministra\Admin\Adapter\DataTableAdapter;
use Ministra\Admin\Container\SilexPsrContainer;
use Ministra\Admin\Lib\Middleware\Pipelines;
use Ministra\Admin\Repository\LicenseKeysRepository;
use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\U4e3ede94d38628311aad24bb0e64cd4b;
use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\d797a7da081d8d4ca3303ecedd9d870a\c13b0cee244b38336fcc529ac7305cd1a;
use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\a6c00121515f022f765ff8278db104e7 as g805818ba6d4881b1b3f97846753b3fe4;
use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\S19459507551cde6c0b7d1f7076be0a50\dba1f9df695158356d7714b187413299;
use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\S19459507551cde6c0b7d1f7076be0a50\bacac8641c639b5542f1aaaabfc1e5e6;
use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\e6bb436adf595939eee691800070a46d;
use Pimple\Container;
use Pimple\ServiceProviderInterface;
use Psr\Container\ContainerInterface;
use Silex\Application;
class AppServiceProvider implements \Pimple\ServiceProviderInterface
{
    public function register(\Pimple\Container $container)
    {
        $container->offsetSet(\Psr\Container\ContainerInterface::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Container\SilexPsrContainer($app);
        });
        $container->offsetSet('pipelines', function (\Silex\Application $app) {
            return new \Ministra\Admin\Lib\Middleware\Pipelines();
        });
        $this->registerRepository($container);
        $container->offsetSet(\Ministra\Admin\Adapter\DataTableAdapter::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Adapter\DataTableAdapter($app['request_stack']->getCurrentRequest(), $app['db']);
        });
        $this->registerUtilConnection($container);
        $this->registerUtilService($container);
    }
    protected function registerRepository(\Pimple\Container $container)
    {
        $container->offsetSet(\Ministra\Admin\Repository\LicenseKeysRepository::class, function (\Silex\Application $app) {
            return new \Ministra\Admin\Repository\LicenseKeysRepository($app['db']);
        });
    }
    protected function registerUtilConnection(\Pimple\Container $container)
    {
        $file = __DIR__ . '/../../deploy/clear_key_util/db_util.sqlite';
        if (!\file_exists($file)) {
            \file_put_contents($file, '');
        }
        if (!\extension_loaded('pdo_sqlite')) {
            throw new \Exception('SQLite extension missing');
        }
        $container->offsetSet('util.connection', \Doctrine\DBAL\DriverManager::getConnection(['driver' => 'pdo_sqlite', 'path' => $file]));
    }
    protected function registerUtilService(\Pimple\Container $container)
    {
        $container->offsetSet(\Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\S19459507551cde6c0b7d1f7076be0a50\bacac8641c639b5542f1aaaabfc1e5e6::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\S19459507551cde6c0b7d1f7076be0a50\bacac8641c639b5542f1aaaabfc1e5e6($app['util.connection']);
        });
        $container->offsetSet(\Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\S19459507551cde6c0b7d1f7076be0a50\dba1f9df695158356d7714b187413299::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\S19459507551cde6c0b7d1f7076be0a50\dba1f9df695158356d7714b187413299($app['util.connection']);
        });
        $container->offsetSet(\Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\d797a7da081d8d4ca3303ecedd9d870a\c13b0cee244b38336fcc529ac7305cd1a::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\a6c00121515f022f765ff8278db104e7($app['db']);
        });
        $container->offsetSet(\Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\U4e3ede94d38628311aad24bb0e64cd4b::class, function (\Silex\Application $app) {
            return new \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\U4e3ede94d38628311aad24bb0e64cd4b($app->offsetGet(\Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\S19459507551cde6c0b7d1f7076be0a50\dba1f9df695158356d7714b187413299::class), $app->offsetGet(\Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\S19459507551cde6c0b7d1f7076be0a50\bacac8641c639b5542f1aaaabfc1e5e6::class), $app->offsetGet(\Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\d797a7da081d8d4ca3303ecedd9d870a\c13b0cee244b38336fcc529ac7305cd1a::class), \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\g7b875c89b6c005590f68a510257eb0ab\e6bb436adf595939eee691800070a46d::UTIL_BINARY_NAME, $app->offsetGet('util.path'));
        });
    }
}
