<?php

namespace Ministra\Lib;

use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\k8281faec2a4a41f470b00112682ddabf;
use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2;
use Ministra\Lib\Course\CourseGetter;
use Ministra\Lib\Course\ProviderFactory;
class Course implements \Ministra\Lib\StbApi\Course
{
    private $db;
    private $codes;
    private $providerName;
    public function __construct()
    {
        $this->db = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance();
        $this->providerName = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\k8281faec2a4a41f470b00112682ddabf::get('course_provider');
        $providers = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\k8281faec2a4a41f470b00112682ddabf::get('course_providers_for_update');
        if (\array_key_exists($this->providerName, $providers)) {
            $this->codes = $providers[$this->providerName];
        }
    }
    public function getData()
    {
        $provider = \Ministra\Lib\Course\ProviderFactory::build($this->providerName, [$this->codes, $this->db]);
        if ($provider instanceof \Ministra\Lib\Course\CourseGetter) {
            return $provider->getData();
        }
        throw new \Exception(\sprintf('Class "%s" must implement CourseGetter interface', \get_class($provider)));
    }
}
