<?php

namespace Ministra\Lib;

use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2;
use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\U7b993fd611168684ddb26c8f5ab7e336;
class ItvSubscription
{
    private static $itv_subscription = false;
    public static function getBonusChannelsIds($uid)
    {
        if (self::$itv_subscription === false) {
            self::$itv_subscription = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->from('itv_subscription')->where(['uid' => $uid])->get()->first();
        }
        if (empty(self::$itv_subscription)) {
            return [];
        }
        $bonus_ch = self::$itv_subscription['bonus_ch'];
        if (empty($bonus_ch)) {
            return [];
        }
        $bonus_ch_arr = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d4c6e5add31a0fb7d2fbf48536f9ad3a(\Ministra\Lib\System::base64_decode($bonus_ch));
        if (!\is_array($bonus_ch_arr)) {
            return [];
        }
        return $bonus_ch_arr;
    }
    public static function getSubscriptionChannelsIds($uid)
    {
        $user = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->from('users')->where(['id' => (int) $uid])->get()->first();
        if (empty($user)) {
            return [];
        }
        if (\Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\U7b993fd611168684ddb26c8f5ab7e336::getInstance()->E784597d2bea6357dbecd06df697bb97c()) {
            return \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->from('itv')->where(['base_ch' => 0])->get()->all('id');
        }
        if (self::$itv_subscription === false) {
            self::$itv_subscription = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->from('itv_subscription')->where(['uid' => $uid])->get()->first();
        }
        if (empty(self::$itv_subscription)) {
            return [];
        }
        $sub_ch = self::$itv_subscription['sub_ch'];
        if (empty($sub_ch)) {
            return [];
        }
        $sub_ch_arr = @\Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d4c6e5add31a0fb7d2fbf48536f9ad3a(\Ministra\Lib\System::base64_decode($sub_ch));
        if (!\is_array($sub_ch_arr)) {
            return [];
        }
        return $sub_ch_arr;
    }
    public static function updateByUids($uids, $data)
    {
        if (empty($data)) {
            return false;
        }
        if (!\array_key_exists('bonus_ch', $data) || !\is_array($data['bonus_ch'])) {
            $data['bonus_ch'] = [];
        }
        if (!\array_key_exists('sub_ch', $data) || !\is_array($data['sub_ch'])) {
            $data['sub_ch'] = [];
        }
        if (\array_key_exists('sub_ch', $data)) {
            $data['sub_ch'] = \Ministra\Lib\System::base64_encode(\Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\t17d3317196ac950e8b2dfe26f26e5a0c($data['sub_ch']));
        }
        if (\array_key_exists('bonus_ch', $data)) {
            $data['bonus_ch'] = \Ministra\Lib\System::base64_encode(\Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\t17d3317196ac950e8b2dfe26f26e5a0c($data['bonus_ch']));
        }
        $data['addtime'] = 'NOW()';
        $result = false;
        foreach ($uids as $uid) {
            $subscription = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->from('itv_subscription')->where(['uid' => $uid])->get()->first();
            if (empty($subscription)) {
                $result = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->insert('itv_subscription', \array_merge($data, ['uid' => $uid]));
            } else {
                $result = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->update('itv_subscription', $data, ['uid' => $uid]);
            }
        }
        if (!$result) {
            return false;
        }
        return self::getByUids($uids);
    }
    public static function getByUids($uids = array())
    {
        $result = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->select('itv_subscription.*, users.mac as mac, users.ls as ls, ' . 'users.additional_services_on as additional_services_on')->from('itv_subscription')->join('users', 'itv_subscription.uid', 'users.id', 'LEFT');
        if (!empty($uids)) {
            $result = $result->in('uid', $uids);
        }
        $result = $result->get()->all();
        $result = \array_map(function ($item) {
            $item['sub_ch'] = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d4c6e5add31a0fb7d2fbf48536f9ad3a(\Ministra\Lib\System::base64_decode($item['sub_ch']));
            $item['bonus_ch'] = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d4c6e5add31a0fb7d2fbf48536f9ad3a(\Ministra\Lib\System::base64_decode($item['bonus_ch']));
            return $item;
        }, $result);
        return $result;
    }
}
