<?php

namespace Ministra\Lib\RESTAPI\v1;

use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2;
class RESTCommandEpg extends \Ministra\Lib\RESTAPI\v1\RESTCommand
{
    public function __construct()
    {
    }
    public function get(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        return \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->select('id, uri, etag, updated, id_prefix, status')->from('epg_setting')->get()->all();
    }
    public function create(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        $data = $request->getData();
        if (empty($data)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('HTTP POST data is empty');
        }
        $res = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->insert('epg_setting', $data)->insert_id();
        return $res;
    }
    public function delete(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        $identifiers = $request->getIdentifiers();
        if (\count($identifiers) != 1) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Identifier count failed');
        }
        return \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->delete('epg_setting', ['id' => $identifiers[0]]);
    }
}
