<?php

namespace Ministra\Lib\RESTAPI\v1;

use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\U7b993fd611168684ddb26c8f5ab7e336;
class RESTCommandStbModules extends \Ministra\Lib\RESTAPI\v1\RESTCommand
{
    public function get(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        $stb_list = $request->getConvertedIdentifiers();
        if (empty($stb_list)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Empty stb list');
        }
        if (\count($stb_list) != 1) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Only one identifier allowed');
        }
        $uid = $stb_list[0];
        return ['disabled' => \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\U7b993fd611168684ddb26c8f5ab7e336::P00f120db1754246f0d2ec55ee8287908($uid), 'restricted' => \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\U7b993fd611168684ddb26c8f5ab7e336::T45d53148058734197c7050898e7683be($uid)];
    }
    public function update(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        $stb_list = $request->getConvertedIdentifiers();
        if (empty($stb_list)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Empty stb list');
        }
        $uids = $stb_list;
        $data = $request->getPut();
        if (empty($data)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('HTTP PUT data is empty');
        }
        if (!\array_key_exists('disabled', $data) && !\array_key_exists('restricted', $data)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Update data is empty');
        }
        if (\array_key_exists('disabled', $data)) {
            foreach ($uids as $uid) {
                \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\U7b993fd611168684ddb26c8f5ab7e336::G5f653da56ed78542b1c90b5b530e6b57($uid, $data['disabled']);
            }
        }
        if (\array_key_exists('restricted', $data)) {
            foreach ($uids as $uid) {
                \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\U7b993fd611168684ddb26c8f5ab7e336::c2a4401c34309e1d65d3ae7128df5c5d($uid, $data['restricted']);
            }
        }
        return ['disabled' => \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\U7b993fd611168684ddb26c8f5ab7e336::P00f120db1754246f0d2ec55ee8287908($uids[0]), 'restricted' => \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\U7b993fd611168684ddb26c8f5ab7e336::T45d53148058734197c7050898e7683be($uids[0])];
    }
}
