<?php

namespace Ministra\Lib;

use ErrorException;
use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\k8281faec2a4a41f470b00112682ddabf;
use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2;
class Storage
{
    private $storage;
    private $max_failures;
    private $stat_period;
    public function __construct($init_info = array())
    {
        if (empty($init_info)) {
            return;
        }
        if (!empty($init_info['id'])) {
            $this->storage = $this->getById($init_info['id']);
        } else {
            if (!empty($init_info['name'])) {
                $this->storage = $this->getByName($init_info['name']);
            }
        }
        if (empty($this->storage)) {
            throw new \ErrorException('Storage can not be initialized with values: ' . \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\V8ccf097f7e59f19fa27c59a5d026e60f($init_info));
        }
        $this->max_failures = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\k8281faec2a4a41f470b00112682ddabf::getSafe('max_storage_failures', 3);
        $this->stat_period = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\k8281faec2a4a41f470b00112682ddabf::getSafe('storage_stat_period', 300);
    }
    public function getById($id)
    {
        return \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->from('storages')->where(['id' => $id])->get()->first();
    }
    public function getByName($name)
    {
        return \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->from('storages')->where(['storage_name' => $name])->get()->first();
    }
    public function markAsFailed($description = '')
    {
        $this->checkIfInitialized();
        \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->insert('storages_failure', ['storage_id' => $this->storage['id'], 'description' => $description])->insert_id();
        $failures = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->from('storages_failure')->count()->where(['storage_id' => $this->storage['id'], 'added>' => \date('Y-m-d H:i:s', \time() - $this->stat_period)])->get()->counter();
        if ($failures >= $this->max_failures) {
            $this->setOff();
        }
    }
    private function checkIfInitialized()
    {
        if (empty($this->storage)) {
            throw new \ErrorException('Storage not initialized');
        }
        return true;
    }
    public function setOff()
    {
        $this->checkIfInitialized();
        if ($this->storage['status'] == 0) {
            return true;
        }
        $result = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->update('storages', ['status' => 0], ['id' => $this->storage['id']]);
        if ($result) {
            \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->insert('master_log', ['log_txt' => 'Storage ' . $this->storage['storage_name'] . ' has been disabled after ' . $this->max_failures . ' failures in ' . $this->stat_period . 's', 'added' => 'NOW()']);
        }
        return $result;
    }
}
