<?php

namespace Ministra\Lib;

use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2;
use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\U7b993fd611168684ddb26c8f5ab7e336;
class TvGenre
{
    private $language;
    public function setLocale($language)
    {
        $this->language = $language;
        \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\U7b993fd611168684ddb26c8f5ab7e336::getInstance()->edf4c489ed3fb7823deb882e1ec96dd0($this->language);
    }
    public function getById($id, $pretty_id = false)
    {
        if ($pretty_id) {
            $genres = $this->getAll($pretty_id, true);
            $genres = \array_filter($genres, function ($genre) use($id) {
                return $id == $genre['id'];
            });
            if (empty($genres)) {
                return;
            }
            $genres = \array_values($genres);
            return \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->from('tv_genre')->where(['id' => $genres[0]['_id']])->get()->first();
        }
        return \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->from('tv_genre')->where(['id' => (int) $id])->get()->first();
    }
    public function getAll($pretty_id = false, $include_internal_id = false)
    {
        $genres = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->from('tv_genre')->orderby('number')->get()->all();
        $genres = \array_map(function ($item) use($pretty_id, $include_internal_id) {
            if ($include_internal_id) {
                $item['_id'] = $item['id'];
            }
            if ($pretty_id) {
                $item['id'] = \preg_replace(["/\\s/i", '/[^a-z0-9-]/i'], ['-', ''], $item['title']);
            }
            $item['censored'] = (bool) $item['censored'];
            $item['title'] = \_($item['title']);
            return $item;
        }, $genres);
        return $genres;
    }
}
