<?php

namespace Ministra\Lib;

use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2;
use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\U7b993fd611168684ddb26c8f5ab7e336;
class VideoCategory
{
    private $language;
    public function setLocale($language)
    {
        $this->language = $language;
        \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\U7b993fd611168684ddb26c8f5ab7e336::getInstance()->edf4c489ed3fb7823deb882e1ec96dd0($this->language);
    }
    public function getById($id, $pretty_id = false)
    {
        if ($pretty_id) {
            $categories = $this->getAll($pretty_id);
            $categories = \array_filter($categories, function ($category) use($id) {
                return $id == $category['id'];
            });
            if (empty($categories)) {
                return;
            }
            $categories = \array_values($categories);
            $category = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->from('media_category')->where(['category_name' => $categories[0]['original_title']])->get()->first();
            if (!empty($category)) {
                $category['id'] = $id;
            }
            return $category;
        }
        return \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->from('media_category')->where(['id' => (int) $id])->get()->first();
    }
    public function getAll($pretty_id = false)
    {
        $categories = \Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\d3507c2999d38573a0a0c91771d70af2::getInstance()->from('media_category')->orderby('num')->get()->all();
        $categories = \array_map(function ($item) use($pretty_id) {
            if ($pretty_id) {
                $item['id'] = \preg_replace('/_/i', '-', $item['category_alias']);
            }
            $item['original_title'] = $item['category_name'];
            $item['title'] = \_($item['category_name']);
            $item['censored'] = (bool) $item['censored'];
            return $item;
        }, $categories);
        return $categories;
    }
}
