<?php

namespace Ministra\Lib;

use Exception;
use Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\k8281faec2a4a41f470b00112682ddabf;
class Weather implements \Ministra\Lib\StbApi\Weather
{
    protected $provider;
    public function __construct()
    {
        $this->provider = $this->getProvider();
    }
    private function getProvider()
    {
        $class = __NAMESPACE__ . '\\' . \ucfirst(\Ministra\Lib\w13ec15f0067ea75861e61e27c990e4ba\k8281faec2a4a41f470b00112682ddabf::getSafe('weather_provider', 'weatherco'));
        if (!\class_exists($class)) {
            throw new \Exception('Resource "' . $class . '" does not exist');
        }
        return new $class();
    }
    public function getCurrent()
    {
        return $this->provider->getCurrent();
    }
    public function getForecast()
    {
        return $this->provider->getForecast();
    }
    public function updateFullCurrent()
    {
        return $this->provider->updateFullCurrent();
    }
    public function updateFullForecast()
    {
        return $this->provider->updateFullForecast();
    }
    public function getCities($country, $search = '')
    {
        return $this->provider->getCities($country, $search);
    }
    public function getCityFieldName()
    {
        return $this->provider->getCityFieldName();
    }
}
