<?php

namespace Ministra\Lib;

use Exception;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1;
class Account implements \Ministra\Lib\StbApi\Account
{
    public function subscribeToPackage()
    {
        $package_id = (int) $_REQUEST['package_id'];
        $user = \Ministra\Lib\User::getInstance(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->id);
        $response = [];
        try {
            $response['result'] = $user->subscribeToPackage($package_id);
        } catch (\Ministra\Lib\OssDeny $e) {
            $response['message'] = $e->getMessage();
            \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::a20f97cb01cfd9c64ced741708342afb($e);
        } catch (\Ministra\Lib\OssException $e) {
            $response['message'] = \_('This operation is temporarily unavailable.');
            \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::a20f97cb01cfd9c64ced741708342afb($e);
        }
        return $response;
    }
    public function unsubscribeFromPackage()
    {
        $package_id = (int) $_REQUEST['package_id'];
        $user = \Ministra\Lib\User::getInstance(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->id);
        $response = [];
        try {
            $response['result'] = $user->unsubscribeFromPackage($package_id);
        } catch (\Ministra\Lib\OssDeny $e) {
            $response['message'] = $e->getMessage();
            \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::a20f97cb01cfd9c64ced741708342afb($e);
        } catch (\Ministra\Lib\OssException $e) {
            $response['message'] = \_('This operation is temporarily unavailable.');
            \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::a20f97cb01cfd9c64ced741708342afb($e);
        }
        return $response;
    }
    public function checkPrice()
    {
        $package_id = (int) $_REQUEST['package_id'];
        $user = \Ministra\Lib\User::getInstance(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->id);
        $response = [];
        try {
            $response['result'] = $user->getPriceForPackage($package_id);
        } catch (\Ministra\Lib\OssDeny $e) {
            $response['message'] = $e->getMessage();
            \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::a20f97cb01cfd9c64ced741708342afb($e);
        } catch (\Ministra\Lib\OssException $e) {
            $response['message'] = \_('This operation is temporarily unavailable.');
            \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::a20f97cb01cfd9c64ced741708342afb($e);
        }
        return $response;
    }
    public function checkVideoPrice()
    {
        $video_id = (int) $_REQUEST['video_id'];
        $user = \Ministra\Lib\User::getInstance(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->id);
        $response = [];
        try {
            $package = $user->getPackageByVideoId($video_id);
            if (empty($package)) {
                throw new \Exception(\_('Server error'));
            }
            $response['result'] = $user->getPriceForPackage($package['id']);
            $response['rent_duration'] = $package['rent_duration'];
            $response['package_id'] = $package['id'];
        } catch (\Ministra\Lib\OssDeny $e) {
            $response['message'] = $e->getMessage();
            \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::a20f97cb01cfd9c64ced741708342afb($e);
        } catch (\Ministra\Lib\OssException $e) {
            $response['message'] = \_('This operation is temporarily unavailable.');
            \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::a20f97cb01cfd9c64ced741708342afb($e);
        } catch (\Exception $e) {
            $response['message'] = $e->getMessage();
            \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::a20f97cb01cfd9c64ced741708342afb($e);
        }
        return $response;
    }
    public function rentVideo()
    {
        $video_id = (int) $_REQUEST['video_id'];
        $price = $_REQUEST['price'];
        $user = \Ministra\Lib\User::getInstance(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->id);
        $response = [];
        try {
            $package = $user->getPackageByVideoId($video_id);
            if (empty($package)) {
                throw new \Exception(\_('Server error'));
            }
            if ($price === '0') {
                $oss_result = true;
            } else {
                $oss_result = $user->subscribeToPackage($package['id']);
            }
            $response['result'] = $oss_result;
            $response['rent_duration'] = $package['rent_duration'];
            $response['package_id'] = $package['id'];
            $rent_session_id = $user->rentVideo($video_id, $price);
            $response['rent_info'] = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->from('video_rent')->where(['id' => $rent_session_id])->get()->first();
            $response['rent_info']['expires_in'] = \Ministra\Lib\User::humanDateDiff($response['rent_info']['rent_end_date'], $response['rent_info']['rent_date']);
        } catch (\Ministra\Lib\OssDeny $e) {
            $response['message'] = $e->getMessage();
            \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::a20f97cb01cfd9c64ced741708342afb($e);
        } catch (\Ministra\Lib\OssException $e) {
            $response['message'] = \_('This operation is temporarily unavailable.');
            \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::a20f97cb01cfd9c64ced741708342afb($e);
        } catch (\Exception $e) {
            $response['message'] = $e->getMessage();
            \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::a20f97cb01cfd9c64ced741708342afb($e);
        }
        return $response;
    }
}
