<?php

namespace Ministra\Lib;

use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\U7b1423316998af8498523ab49b7053e6\Z0123335d0e9312494791d8030b626dff;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1;
class ItvSubscription
{
    private static $itv_subscription = false;
    public static function getBonusChannelsIds($uid)
    {
        if (self::$itv_subscription === false) {
            self::$itv_subscription = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->from('itv_subscription')->where(['uid' => $uid])->get()->first();
        }
        if (empty(self::$itv_subscription)) {
            return [];
        }
        $bonus_ch = self::$itv_subscription['bonus_ch'];
        if (empty($bonus_ch)) {
            return [];
        }
        $bonus_ch_arr = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\U7b1423316998af8498523ab49b7053e6\Z0123335d0e9312494791d8030b626dff::q8ed3cd8b3dd6b9da2bb2248a80d8859b(\Ministra\Lib\System::base64_decode($bonus_ch));
        if (!\is_array($bonus_ch_arr)) {
            return [];
        }
        return $bonus_ch_arr;
    }
    public static function getSubscriptionChannelsIds($uid)
    {
        $user = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->from('users')->where(['id' => (int) $uid])->get()->first();
        if (empty($user)) {
            return [];
        }
        if (\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::getInstance()->G33a045f2bd8324c924e131cf19ff3200()) {
            return \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->from('itv')->where(['base_ch' => 0])->get()->all('id');
        }
        if (self::$itv_subscription === false) {
            self::$itv_subscription = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->from('itv_subscription')->where(['uid' => $uid])->get()->first();
        }
        if (empty(self::$itv_subscription)) {
            return [];
        }
        $sub_ch = self::$itv_subscription['sub_ch'];
        if (empty($sub_ch)) {
            return [];
        }
        $sub_ch_arr = @\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\U7b1423316998af8498523ab49b7053e6\Z0123335d0e9312494791d8030b626dff::q8ed3cd8b3dd6b9da2bb2248a80d8859b(\Ministra\Lib\System::base64_decode($sub_ch));
        if (!\is_array($sub_ch_arr)) {
            return [];
        }
        return $sub_ch_arr;
    }
    public static function updateByUids($uids, $data)
    {
        if (empty($data)) {
            return false;
        }
        if (!\array_key_exists('bonus_ch', $data) || !\is_array($data['bonus_ch'])) {
            $data['bonus_ch'] = [];
        }
        if (!\array_key_exists('sub_ch', $data) || !\is_array($data['sub_ch'])) {
            $data['sub_ch'] = [];
        }
        if (\array_key_exists('sub_ch', $data)) {
            $data['sub_ch'] = \Ministra\Lib\System::base64_encode(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\U7b1423316998af8498523ab49b7053e6\Z0123335d0e9312494791d8030b626dff::y08f4e0044959ef2ebbd1e3b0db7ed4ee($data['sub_ch']));
        }
        if (\array_key_exists('bonus_ch', $data)) {
            $data['bonus_ch'] = \Ministra\Lib\System::base64_encode(\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\U7b1423316998af8498523ab49b7053e6\Z0123335d0e9312494791d8030b626dff::y08f4e0044959ef2ebbd1e3b0db7ed4ee($data['bonus_ch']));
        }
        $data['addtime'] = 'NOW()';
        $result = false;
        foreach ($uids as $uid) {
            $subscription = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->from('itv_subscription')->where(['uid' => $uid])->get()->first();
            if (empty($subscription)) {
                $result = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->insert('itv_subscription', \array_merge($data, ['uid' => $uid]));
            } else {
                $result = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->update('itv_subscription', $data, ['uid' => $uid]);
            }
        }
        if (!$result) {
            return false;
        }
        return self::getByUids($uids);
    }
    public static function getByUids($uids = array())
    {
        $result = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\B4291b8d8fa2d898727b1f446db1e661e::getInstance()->select('itv_subscription.*, users.mac as mac, users.ls as ls, ' . 'users.additional_services_on as additional_services_on')->from('itv_subscription')->join('users', 'itv_subscription.uid', 'users.id', 'LEFT');
        if (!empty($uids)) {
            $result = $result->in('uid', $uids);
        }
        $result = $result->get()->all();
        $result = \array_map(function ($item) {
            $item['sub_ch'] = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\U7b1423316998af8498523ab49b7053e6\Z0123335d0e9312494791d8030b626dff::q8ed3cd8b3dd6b9da2bb2248a80d8859b(\Ministra\Lib\System::base64_decode($item['sub_ch']));
            $item['bonus_ch'] = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\U7b1423316998af8498523ab49b7053e6\Z0123335d0e9312494791d8030b626dff::q8ed3cd8b3dd6b9da2bb2248a80d8859b(\Ministra\Lib\System::base64_decode($item['bonus_ch']));
            return $item;
        }, $result);
        return $result;
    }
}
