<?php

namespace Ministra\Lib\RESTAPI\v1;

use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\f1346478e91df21aff77c1e1db9ef4c7;
use Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1;
use Ministra\Lib\Reseller;
use Ministra\Lib\User;
class RESTCommandAccounts extends \Ministra\Lib\RESTAPI\v1\RESTCommand
{
    public function get(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        $identifiers = $request->getIdentifiers();
        $users_ids = $this->getUsersIdsFromIdentifiers($identifiers);
        if (\count($identifiers) == 1 && \count($users_ids) == 0) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Account not found');
        }
        if ($identifiers != null && \count($identifiers) > \count($users_ids)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('One or more identifiers are incorrect');
        }
        $result = [];
        foreach ($users_ids as $user_id) {
            $user = \Ministra\Lib\User::getInstance($user_id);
            $result[] = $user->getAccountInfo();
            \Ministra\Lib\User::clear();
        }
        return $result;
    }
    protected function getUsersIdsFromIdentifiers($identifiers)
    {
        if (!empty($identifiers[0]) && \strlen($identifiers[0]) >= 12 && \strpos($identifiers[0], ':')) {
            return \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::j62365df04c2c18153e9f2d23e33a05f7($identifiers);
        }
        return \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\bcb5276dcc10d28aee463111bf6dfaa1::r2daec3ad4fc58a3fb3a097f0bdd5abcc($identifiers);
    }
    public function create(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        $data = $request->getData();
        if (empty($data)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('HTTP POST data is empty');
        }
        $allowed_to_update_fields = ['login', 'password', 'full_name', 'phone', 'account_number', 'tariff_plan', 'tariff_expired_date', 'tariff_instead_expired', 'status', 'stb_mac', 'comment', 'end_date', 'account_balance'];
        if (\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c::getSafe('allow_resellers_info_for_api', false)) {
            $allowed_to_update_fields[] = 'reseller_id';
        }
        $account = \array_intersect_key($data, \array_fill_keys($allowed_to_update_fields, true));
        if (empty($account)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Insert data is empty');
        }
        if (!empty($account['stb_mac'])) {
            $mac = \Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\f1346478e91df21aff77c1e1db9ef4c7::fd9f9012489fb983d38212d424947e9a($account['stb_mac']);
            if (!$mac) {
                throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Not valid mac address');
            }
            $account['stb_mac'] = $mac;
        }
        if (empty($account['login'])) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Login required');
        }
        $user = \Ministra\Lib\User::getByLogin($account['login']);
        if (!empty($user)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Login already in use');
        }
        if (!empty($account['stb_mac'])) {
            $user = \Ministra\Lib\User::getByMac($account['stb_mac']);
            if (!empty($user)) {
                throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('MAC address already in use');
            }
        }
        if (!empty($account['reseller_id'])) {
            $reseller = new \Ministra\Lib\Reseller($account['reseller_id']);
            if (empty($reseller->getDBData())) {
                throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Reseller does not exist');
            }
        }
        return (bool) \Ministra\Lib\User::createAccount($account);
    }
    public function update(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        $data = $request->getData();
        if (empty($data)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('HTTP POST data is empty');
        }
        $allowed_to_update_fields = ['login', 'password', 'full_name', 'phone', 'account_number', 'tariff_plan', 'tariff_expired_date', 'tariff_instead_expired', 'status', 'stb_mac', 'comment', 'end_date', 'account_balance'];
        if (\Ministra\Lib\bd5c9022e9a9029209e5fd05775ea272\K131970f0a776522b1a53ba419cd5e32c::getSafe('allow_resellers_info_for_api', false)) {
            $allowed_to_update_fields[] = 'reseller_id';
        }
        $account = \array_intersect_key($data, \array_fill_keys($allowed_to_update_fields, true));
        if (empty($account)) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Insert data is empty');
        }
        $identifiers = $request->getIdentifiers();
        if (\count($identifiers) == 0) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Identifier required');
        }
        $users_ids = $this->getUsersIdsFromIdentifiers($identifiers);
        if (\count($identifiers) == 1 && \count($users_ids) == 0) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Account not found');
        }
        if (\count($identifiers) > 1) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Only one identifier allowed');
        }
        if (!empty($account['login'])) {
            $user = \Ministra\Lib\User::getByLogin($account['login']);
            if (!empty($user) && ($user->getId() != $users_ids[0] || \count($users_ids) > 1)) {
                throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Login already in use');
            }
        }
        if (!empty($account['reseller_id'])) {
            $reseller = new \Ministra\Lib\Reseller($account['reseller_id']);
            if (empty($reseller->getDBData())) {
                throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Reseller does not exist');
            }
        }
        $result = true;
        foreach ($users_ids as $user_id) {
            $user = \Ministra\Lib\User::getInstance($user_id);
            $result = $user->updateAccount($account) && $result;
            \Ministra\Lib\User::clear();
        }
        return $result;
    }
    public function delete(\Ministra\Lib\RESTAPI\v1\RESTRequest $request)
    {
        $identifiers = $request->getIdentifiers();
        if (\count($identifiers) == 0) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Identifier required');
        }
        $users_ids = $this->getUsersIdsFromIdentifiers($identifiers);
        if (\count($identifiers) == 1 && \count($users_ids) == 0) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Account not found');
        }
        if (\count($identifiers) > 1) {
            throw new \Ministra\Lib\RESTAPI\v1\RESTCommandException('Only one identifier allowed');
        }
        $result = true;
        foreach ($users_ids as $user_id) {
            $user = \Ministra\Lib\User::getInstance($user_id);
            $result = $user->delete() && $result;
            \Ministra\Lib\User::clear();
        }
        return $result;
    }
}
